//hq2x filter demo program
//----------------------------------------------------------
//Copyright (C) 2003 MaxSt ( maxst@hiend3d.com )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later
//version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

extern "C"
{
void __cdecl hq2x_16(unsigned char *srcPtr, unsigned char *dstPtr,
					 int width, int height, unsigned int dstPitch,
					 unsigned char *deltaPtr);
/*void __cdecl hq2x_16(unsigned char*, unsigned char*, DWORD, DWORD, DWORD, unsigned char *deltaPtr, unsigned char *dstPtr);*/
unsigned int   LUT16to32[65536];
unsigned int   RGBtoYUV[65536];
}

int InitLUTs(void)
{
	int i, j, k, r, g, b, Y, u, v;

	for (i = 0; i < 65536; i++)
		LUT16to32[i] = ((i & 0xF800) << 8) + ((i & 0x07E0) << 5) + ((i & 0x001F) << 3);

	for (i = 0; i < 32; i++)
		for (j = 0; j < 64; j++)
			for (k =0; k < 32; k++) {
				r = i << 3;
				g = j << 2;
				b = k << 3;
				Y = (r + g + b) >> 2;
				u = 128 + ((r - b) >> 2);
				v = 128 + ((-r + 2 * g - b) >> 3);
				RGBtoYUV[ (i << 11) + (j << 5) + k ] = (Y << 16) + (u << 8) + v;
			}

  /*int nMMXsupport = 0;

  __asm
  {
    mov  eax, 1
    cpuid
    and  edx, 0x00800000
    mov  nMMXsupport, edx
  }*/

  return 0x00800000/*nMMXsupport*/;
}

void hq2x(unsigned char *srcPtr, unsigned int srcPitch, unsigned char * /* deltaPtr */,
		  unsigned char *dstPtr, unsigned int dstPitch, int width, int height)
{
	hq2x_16(srcPtr, dstPtr, width, height, dstPitch, 0);
}